﻿Imports FMODNet
Public Class Main

#Region "As Good As Finished"
    Public Structure UDM_Image
        Public Name As String
        Public Image As System.Drawing.Bitmap
        Public Sub New(ByVal N As String, ByVal I As System.Drawing.Bitmap)
            Name = N
            Image = I
        End Sub
    End Structure

    Private Sub SetMap(ByVal Width As Integer, ByVal Height As Integer)
        Pic_Ac_Memory_BMP = New System.Drawing.Bitmap(Width * 32, Height * 32, Pic_Ac_Memory_GHX)
        Pic_Ac_Memory_GHX = System.Drawing.Graphics.FromImage(Pic_Ac_Memory_BMP)
        MapWidth = Width
        MapHeight = Height
    End Sub

    Public Sub ChangeFrameSkip()
        If MapHeight = 20 And MapWidth = 20 Then
            FrameSkip = 0 ' Reset count
            FrameSkipAmount = Preferences.Pref_FrameSkip20
        ElseIf MapHeight = 40 And MapWidth = 40 Then
            FrameSkip = 0 ' Reset count
            FrameSkipAmount = Preferences.Pref_FrameSkip40
        ElseIf MapHeight = 80 And MapWidth = 80 Then
            FrameSkip = 0 ' Reset count
            FrameSkipAmount = Preferences.Pref_FrameSkip80
        End If
    End Sub

    Private Sub X20ToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles X20ToolStripMenuItem.Click
        X20ToolStripMenuItem.Checked = True
        ChangeGridSize_1.Checked = True
        X40ToolStripMenuItem.Checked = False
        ChangeGridSize_2.Checked = False
        X80ToolStripMenuItem.Checked = False
        ChangeGridSize_3.Checked = False
        SetMap(20, 20)
        IMG_Grid = EditorResources.DrawGrid(False)
        IMG_GridWithID = EditorResources.DrawGrid(True)
        ChangeFrameSkip() ' Update Frame skip rate
        Viewport_MouseMove(sender, New System.Windows.Forms.MouseEventArgs(Windows.Forms.MouseButtons.None, 0, -1, -1, 0))
    End Sub

    Private Sub X40ToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles X40ToolStripMenuItem.Click
        X20ToolStripMenuItem.Checked = False
        ChangeGridSize_1.Checked = False
        X40ToolStripMenuItem.Checked = True
        ChangeGridSize_2.Checked = True
        X80ToolStripMenuItem.Checked = False
        ChangeGridSize_3.Checked = False
        SetMap(40, 40)
        IMG_Grid = EditorResources.DrawGrid(False)
        IMG_GridWithID = EditorResources.DrawGrid(True)
        ChangeFrameSkip() ' Update Frame skip rate
        Viewport_MouseMove(sender, New System.Windows.Forms.MouseEventArgs(Windows.Forms.MouseButtons.None, 0, -1, -1, 0))
    End Sub

    Private Sub X80ToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles X80ToolStripMenuItem.Click
        X20ToolStripMenuItem.Checked = False
        ChangeGridSize_1.Checked = False
        X40ToolStripMenuItem.Checked = False
        ChangeGridSize_2.Checked = False
        X80ToolStripMenuItem.Checked = True
        ChangeGridSize_3.Checked = True
        SetMap(80, 80)
        IMG_Grid = EditorResources.DrawGrid(False)
        IMG_GridWithID = EditorResources.DrawGrid(True)
        ChangeFrameSkip() ' Update Frame skip rate
        Viewport_MouseMove(sender, New System.Windows.Forms.MouseEventArgs(Windows.Forms.MouseButtons.None, 0, -1, -1, 0))
    End Sub

    Private Sub NoneToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles NoneToolStripMenuItem.Click
        GridMode = "nothing"
        Viewport_MouseMove(sender, New System.Windows.Forms.MouseEventArgs(Windows.Forms.MouseButtons.None, 0, -1, -1, 0))
        NoneToolStripMenuItem.Checked = True
        GridToolStripMenuItem.Checked = False
        GridWithNumbersToolStripMenuItem.Checked = False
        ChangeGridMode_1.Checked = True
        ChangeGridMode_2.Checked = False
        ChangeGridMode_3.Checked = False
    End Sub

    Private Sub GridToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles GridToolStripMenuItem.Click
        GridMode = "grid"
        Viewport_MouseMove(sender, New System.Windows.Forms.MouseEventArgs(Windows.Forms.MouseButtons.None, 0, -1, -1, 0))
        NoneToolStripMenuItem.Checked = False
        GridToolStripMenuItem.Checked = True
        GridWithNumbersToolStripMenuItem.Checked = False
        ChangeGridMode_1.Checked = False
        ChangeGridMode_2.Checked = True
        ChangeGridMode_3.Checked = False
    End Sub

    Private Sub GridWithNumbersToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles GridWithNumbersToolStripMenuItem.Click
        GridMode = "grid+ID"
        Viewport_MouseMove(sender, New System.Windows.Forms.MouseEventArgs(Windows.Forms.MouseButtons.None, 0, -1, -1, 0))
        NoneToolStripMenuItem.Checked = False
        GridToolStripMenuItem.Checked = False
        GridWithNumbersToolStripMenuItem.Checked = True
        ChangeGridMode_1.Checked = False
        ChangeGridMode_2.Checked = False
        ChangeGridMode_3.Checked = True
    End Sub

    Private Sub ExitToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ExitToolStripMenuItem.Click
        Me.Close()
    End Sub

    Dim IsFullscreen As Boolean = False
    Dim OldFullscreen As Integer = 0
    Private Sub FullscreenToggleToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles FullscreenToggleToolStripMenuItem.Click
        If Not IsFullscreen Then
            IsFullscreen = True
            FullscreenToggle.Checked = True
            FullscreenToggleToolStripMenuItem.Checked = True
            If Me.WindowState = FormWindowState.Maximized Then
                OldFullscreen = Me.WindowState
                Me.WindowState = FormWindowState.Normal
                Me.FormBorderStyle = Windows.Forms.FormBorderStyle.None
                Me.WindowState = FormWindowState.Maximized
            Else
                Me.FormBorderStyle = Windows.Forms.FormBorderStyle.None
                OldFullscreen = Me.WindowState
                Me.WindowState = FormWindowState.Maximized
            End If
        Else
            FullscreenToggle.Checked = False
            FullscreenToggleToolStripMenuItem.Checked = False
            IsFullscreen = False
            Me.FormBorderStyle = Windows.Forms.FormBorderStyle.FixedSingle
            Me.WindowState = OldFullscreen
        End If
    End Sub

    Private Sub ExternalPluginsToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ExternalPluginsToolStripMenuItem.Click
        ExternalPlugins.Owner = Me
        ExternalPlugins.ShowDialog()
    End Sub

    Private Sub IndexToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles IndexToolStripMenuItem.Click
        Try
            Process.Start(ServerLink + "Henry00/00UDC/dungeon%20maker/help/index.htm")
        Catch Ex As Exception
        End Try
    End Sub

    Private Sub MusicBrowserToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MusicBrowserToolStripMenuItem.Click
        MusicPlayer.Owner = Me
        MusicPlayer.Show()
    End Sub

    Private Sub MapInformationToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MapInformationToolStripMenuItem.Click
        MapInformationGUI.Owner = Me
        MapInformationGUI.ShowDialog()
    End Sub

    'TOOL STRIP
#Region "ToolStrip"
    Private Sub ExportBitmapImageToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ExportBitmapImageToolStripMenuItem.Click
        ExportBMP.Owner = Me
        ExportBMP.ShowDialog()
    End Sub

    Private Sub DruckenToolStripButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles DruckenToolStripButton.Click
        ExportBitmapImageToolStripMenuItem_Click(sender, e)
    End Sub

    Private Sub SpeichernToolStripButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SpeichernToolStripButton.Click
        SaveDungeonToolStripMenuItem_Click(sender, e)
    End Sub

    Private Sub ÖffnenToolStripButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ÖffnenToolStripButton.Click
        LoadDungeonToolStripMenuItem_Click(sender, e)
    End Sub

    Private Sub NeuToolStripButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles NeuToolStripButton.Click
        NewDungeonToolStripMenuItem_Click(sender, e)
    End Sub

    Private Sub ChangeGridMode_1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ChangeGridMode_1.Click
        NoneToolStripMenuItem_Click(sender, e)
    End Sub

    Private Sub ChangeGridMode_2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ChangeGridMode_2.Click
        GridToolStripMenuItem_Click(sender, e)
    End Sub

    Private Sub ChangeGridMode_3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ChangeGridMode_3.Click
        GridWithNumbersToolStripMenuItem_Click(sender, e)
    End Sub

    Private Sub ChangeGridSize_1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ChangeGridSize_1.Click
        X20ToolStripMenuItem_Click(sender, e)
    End Sub

    Private Sub ChangeGridSize_2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ChangeGridSize_2.Click
        X40ToolStripMenuItem_Click(sender, e)
    End Sub

    Private Sub ChangeGridSize_3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ChangeGridSize_3.Click
        X80ToolStripMenuItem_Click(sender, e)
    End Sub

    Private Sub ExternalPluginsTool_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ExternalPluginsTool.Click
        ExternalPluginsToolStripMenuItem_Click(sender, e)
    End Sub

    Private Sub FullscreenToggle_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles FullscreenToggle.Click
        FullscreenToggleToolStripMenuItem_Click(sender, e)
    End Sub

    Private Sub PropertiesToolStrip_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PropertiesToolStrip.Click
        PrefrencesToolStripMenuItem_Click(sender, e)
    End Sub

    Private Sub SaveDungeonAsToolStripButton2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SaveDungeonAsToolStripButton2.Click
        SaveDungeonAsToolStripMenuItem_Click(sender, e)
    End Sub

    Private Sub RectangleToolStripButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RectangleToolStripButton.Click
        Drawing_Mode = "rectangle"
        PencilToolStripButton.Checked = False
        RectangleToolStripButton.Checked = True
    End Sub

    Private Sub PencilToolStripButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PencilToolStripButton.Click
        Drawing_Mode = "pencil"
        RectangleToolStripButton.Checked = False
        PencilToolStripButton.Checked = True
    End Sub

    Private Sub ViewMapCollectionToolStripButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ViewMapCollectionToolStripButton.Click
        ViewMapCollectionToolStripMenuItem_Click(sender, e)
    End Sub

    Private Sub UpdateResourcesToolStrip_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles UpdateResourcesToolStrip.Click
        UpdateResourcesToolStripMenuItem_Click(sender, e)
    End Sub

    'Export t3d
    Private Sub ToolStripButton1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ToolStripButton1.Click
        ExportDungeonToolStripMenuItem_Click(sender, e)
    End Sub
#End Region
    'END TOOL STRIP

    Private Sub DownloadDemoToSendToFriendsToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles DownloadDemoToSendToFriendsToolStripMenuItem.Click
        Try
            Process.Start("http://henry00.ftpaccess.cc/")
        Catch ex As Exception
            MsgBox("An error occured:" + vbNewLine + ex.Message)
        End Try
    End Sub

    Private Sub VisitOldUnrealToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles VisitOldUnrealToolStripMenuItem.Click
        Try
            Process.Start("http://www.oldunreal.com/")
        Catch ex As Exception
            MsgBox("An error occured:" + vbNewLine + ex.Message)
        End Try
    End Sub

    Private Sub OpenDeveloperChatToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles OpenDeveloperChatToolStripMenuItem.Click
        Chat.Owner = Me
        Chat.Show()
    End Sub

    Private Sub ViewMapCollectionToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ViewMapCollectionToolStripMenuItem.Click
        MapCollection.ShowDialog()
    End Sub

    Private Sub LayerSettingsToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles LayerSettingsToolStripMenuItem.Click
        LayerSetting.Owner = Me
        LayerSetting.EveryLayerNewFloorRadio.Checked = False
        LayerSetting.MergeHeightSkipLayerForNewFloorRadio.Checked = False
        If MyMap_LayerSetting = 0 Then
            LayerSetting.EveryLayerNewFloorRadio.Checked = True
        Else
            LayerSetting.MergeHeightSkipLayerForNewFloorRadio.Checked = True
        End If
        LayerSetting.ShowDialog()
    End Sub
#End Region
#Region "Variables"
    Dim Pic_Ac_Memory_GHX As System.Drawing.Graphics = System.Drawing.Graphics.FromImage(New System.Drawing.Bitmap(800, 608))
    Dim Pic_Ac_Memory_BMP As New System.Drawing.Bitmap(800, 608, Pic_Ac_Memory_GHX)
    Dim Do_Reboot As Boolean = False

    Public Shared ServerLink As String = "http://henry00.ftpaccess.cc/"

    Public Shared IMG_Cursor As System.Drawing.Bitmap = EditorResources.CreateSelectionMapEditorBox

    '----

    Public Shared IMG_Representations As New List(Of UDM_Image)

    Public Shared IMG_Grid As System.Drawing.Bitmap = New Bitmap(10, 10)
    Public Shared IMG_GridWithID As System.Drawing.Bitmap = New Bitmap(10, 10)

    '----
    Public CheckForUpdatesInTheEndFN As String = ""
    '----
    Private m_PanStartPoint As New Point(0, 0)
    Public Shared Mouse_SpotOnClick As System.Drawing.PointF
    Public Shared Mouse_SpotOnMove As System.Drawing.PointF
    Public Shared Mouse_IsDrawing As Boolean
    '----
    Public ShowGrid As Boolean = True
    Public ShowGridNumbers As Boolean = False
    Public MapWidth As Integer = 20
    Public MapHeight As Integer = 20
    Public GridMode As String = "grid"
    ' Loaded map info etc:
    Public Shared GUI_Title As String = "UnrealED dungeon maker3 - 00 Unreal development collection"
    Public Shared LoadedMapFileName As String = "new.<henry"
    Public Shared LoadedMapFileFull As String = "new.<henry"
    Public Shared RecentFilePath As String = My.Application.Info.DirectoryPath + "\Levels"
    Public Shared RecentExportPath As String = My.Application.Info.DirectoryPath + "\Levels"
    ' On boot special:
    Dim CommandLineLoadMap As Boolean = False
    Dim CommandLineLoadMapN As String = ""
    Dim QuitApp As Boolean = False
    '----
    Dim FrameSkip As Integer = 0
    Dim FrameSkipAmount As Integer = 0
    '----
    Public Shared CheckForToolsThatMustRunInTheEnd As Boolean = False
    '----
    Public Shared Drawing_Mode As String = "pencil"
    Public Shared Drawing_Layer As String = "0"
    '----
    Public Shared MyMap_Song As String = ""
    Public Shared MyMap_LayerSetting As Integer = 0
    Public Shared MyMap_Info_Author As String = ""
    Public Shared MyMap_Info_Comments As String = ""
    '----
    Public Shared GlobalSoundPlayed As Sound
    Public Shared GlobalSoundDevice As New SoundDevice
    Public Shared GlobalSoundCanPlay As Boolean = True
    Public Shared GlobalSoundInitializedQ As Boolean = False
    '----
    Public Shared ShowSpecialMaker As Boolean = False
    Public Shared SpecialMarkerPos As System.Drawing.PointF = New System.Drawing.PointF(0, 0)
    Public Shared SpecialMarkerImg As System.Drawing.Bitmap = EditorResources.CreateSpecialMarker
#End Region
#Region "Boot"
    Dim DownloadThread As New Threading.Thread(AddressOf DownloadTheNews)
    ' Download the latest news before starting..
    Dim the_news As String = "Downloading news..."

    Private Sub Main_FormClosed(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosedEventArgs) Handles Me.FormClosed
        End
    End Sub

    Private Sub Intro_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Try
            CheckForIllegalCrossThreadCalls = False
            Me.Show()
            Me.News_Label.Text = the_news
            If System.Diagnostics.Debugger.IsAttached Then
                ServerLink = "http://192.168.0.110/"
            End If
            Try
                If My.Computer.FileSystem.FileExists(My.Application.Info.DirectoryPath + "\settings\cversion.cfg") Then
                    GUI_Title = "UnrealED dungeon maker V:3." + System.IO.File.ReadAllText(My.Application.Info.DirectoryPath + "\settings\cversion.cfg", System.Text.Encoding.Default) + " - 00 Unreal development collection"
                    Me.Text = "UnrealED dungeon maker V:3." + System.IO.File.ReadAllText(My.Application.Info.DirectoryPath + "\settings\cversion.cfg", System.Text.Encoding.Default) + " - 00 Unreal development collection"
                End If
            Catch ex As Exception
            End Try
            Ticker.Start()
            Me.Refresh()
            DownloadThread.Start()
        Catch Ex As Exception
        End Try
    End Sub
    Dim HideCounter_01 As Integer = 0
    Private Sub Ticker_Tick(ByVal sender As Object, ByVal e As System.EventArgs) Handles Ticker.Tick
        Try
            If News_Label.Location.X + News_Label.Width < 1 Then
                News_Label.Location = New Point(Me.Width, News_Label.Location.Y)
            Else
                News_Label.Location = New Point(News_Label.Location.X - 3, News_Label.Location.Y)
            End If
            If MainToolTip.Active Then
                If HideCounter_01 > 39 Then
                    MainToolTip.Hide(ToolBox)
                    MainToolTip.Hide(GC_C_List)
                    HideCounter_01 = 0
                Else
                    HideCounter_01 += 1
                End If
            End If
        Catch Ex As Exception
        End Try
    End Sub
    Sub DownloadTheNews()
        While True
            Try
                If My.Computer.Network.IsAvailable Then
                    the_news = New Net.WebClient().DownloadString(New System.Uri(ServerLink + "Henry00/00UDC/news.txt"))
                    If the_news = "Downloading news..." Then
                        News_Label.Text = "Failed downloading the news, try again at a later time."
                    Else
                        News_Label.Text = the_news
                    End If
                Else
                    News_Label.Text = "You currently have no connection to the internet!"
                End If
                News_Label.Location = New Point(Me.Width, News_Label.Location.Y)
            Catch ex As Exception
                News_Label.Text = "Failed downloading the news, try again at a later time."
            End Try
            Try
                If My.Computer.Network.IsAvailable Then
                    If My.Computer.FileSystem.FileExists(My.Application.Info.DirectoryPath + "\settings\cversion.cfg") Then
                        If New Net.WebClient().DownloadString(New System.Uri(ServerLink + "Henry00/00UDC/dungeon maker/version.txt")) <> System.IO.File.ReadAllText(My.Application.Info.DirectoryPath + "\settings\cversion.cfg", System.Text.Encoding.Default) Then
                            Me.Text += " [New update available]"
                        End If
                    End If
                End If
            Catch ex As Exception

            End Try
            Threading.Thread.Sleep(System.Threading.Timeout.Infinite)
        End While
    End Sub
#End Region
#Region "Layers"
    Public Structure UDM_GRID
        Public Structure UDM_CELL
            Public X As Integer
            Public Y As Integer
            Public Tile As String
            Public Actor As String
        End Structure
        Public SContainsTileNameResult As String
        Public SContainsTileCELLResult As UDM_CELL
        Public Function SContains(ByVal X As Integer, ByVal Y As Integer, ByVal TheName As String, ByVal IsTile As Boolean, Optional ByVal OnLayer As String = "") As Boolean
            If IsTile Then
                For Each I As UDM_CELL In AllPoints
                    If I.X = X And I.Y = Y Then
                        If OnLayer <> "" Then
                            If I.Actor = OnLayer Then
                                SContainsTileNameResult = I.Tile
                                SContainsTileCELLResult = I
                                Return True
                            Else
                                SContainsTileNameResult = ""
                                SContainsTileCELLResult = Nothing
                            End If
                        Else
                            If I.Actor = Main.Drawing_Layer Then
                                SContainsTileNameResult = I.Tile
                                SContainsTileCELLResult = I
                                Return True
                            Else
                                SContainsTileNameResult = ""
                                SContainsTileCELLResult = Nothing
                            End If
                        End If
                    End If
                Next
            End If
            Return False
        End Function
        Public Function Slay(ByVal X As Integer, ByVal Y As Integer, ByVal IsTile As Boolean, Optional ByVal JustKill As Boolean = False)
            Try
                If IsTile Then
                    Dim XX As New List(Of UDM_CELL)
                    XX.AddRange(AllPoints)
                    For Each I As UDM_CELL In XX
                        If I.X = X And I.Y = Y Then
                            If Main.ToolBox.SelectedItems.Count > 0 Then
                                If I.Tile <> Main.ToolBox.SelectedItems.Item(0).Text Or JustKill Then
                                    If I.Actor = Main.Drawing_Layer Then
                                        AllPoints.Remove(I)
                                        Return True
                                    End If
                                End If
                            Else
                                If JustKill Then
                                    If I.Actor = Main.Drawing_Layer Then
                                        AllPoints.Remove(I)
                                        Return True
                                    End If
                                End If
                            End If
                        End If
                    Next
                End If
            Catch Ex As Exception
            End Try
            Return False
        End Function
    End Structure
    Public Shared _MAP_HALLWAYS As New UDM_GRID
    Public Shared AllPoints As New List(Of UDM_GRID.UDM_CELL)

    Public Structure UDM_AGRID
        Public Structure UDM_CELL
            Public X As Integer
            Public Y As Integer
            Public Tile As String
            Public Actor As String
        End Structure
        Public SContainsTileNameResult As String
        Public SContainsTileCELLResult As UDM_CELL
        Public Function SContains(ByVal X As Integer, ByVal Y As Integer, ByVal TheName As String, ByVal IsTile As Boolean, Optional ByVal OnLayer As String = "") As Boolean
            If IsTile Then
                For Each I As UDM_CELL In AllAPoints
                    If OnLayer <> "" Then
                        If I.Actor = OnLayer Then
                            If I.X = X And I.Y = Y Then
                                SContainsTileNameResult = I.Tile
                                SContainsTileCELLResult = I
                                Return True
                            Else
                                SContainsTileNameResult = ""
                                SContainsTileCELLResult = Nothing
                            End If
                        End If
                    Else
                        If I.Actor = Main.Drawing_Layer Then
                            If I.X = X And I.Y = Y Then
                                SContainsTileNameResult = I.Tile
                                SContainsTileCELLResult = I
                                Return True
                            Else
                                SContainsTileNameResult = ""
                                SContainsTileCELLResult = Nothing
                            End If
                        End If
                    End If
                Next
            End If
            Return False
        End Function
        Public Function Slay(ByVal X As Integer, ByVal Y As Integer, ByVal IsTile As Boolean, Optional ByVal JustKill As Boolean = False)
            If IsTile Then
                Dim XX As New List(Of UDM_CELL)
                XX.AddRange(AllAPoints)
                For Each I As UDM_CELL In XX
                    If I.X = X And I.Y = Y Then
                        If I.Tile <> Main.GC_C_List.Text Or JustKill Then
                            If I.Actor = Main.Drawing_Layer Then
                                AllAPoints.Remove(I)
                                Return True
                            End If
                        End If
                    End If
                Next
            End If
            Return False
        End Function
    End Structure
    Public Shared _MAP_HALLWAYSA As New UDM_AGRID
    Public Shared AllAPoints As New List(Of UDM_AGRID.UDM_CELL)
#End Region

    Private Sub Main_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        If AllPoints.Count > 0 Or AllAPoints.Count > 0 Then
            If MsgBox("Would you like to save your dungeon?", MsgBoxStyle.YesNo) = MsgBoxResult.Yes Then
                SaveDungeonToolStripMenuItem_Click(sender, e)
            End If
        End If
        QuitApp = True
        Try
            Dim Y As Windows.Forms.FormCollection = My.Application.OpenForms
            For Each L As Windows.Forms.Form In Y
                If Not L Is Me Then
                    L.Close()
                End If
            Next
        Catch Ex As Exception
        End Try
        'Me.Hide()
        Threading.Thread.Sleep(200)
        Try
            My.Computer.FileSystem.DeleteFile(My.Application.Info.DirectoryPath + "\chat.htm")
        Catch Ex As Exception
        End Try
        If CheckForToolsThatMustRunInTheEnd Then
            Try
                If My.Computer.FileSystem.FileExists(My.Application.Info.DirectoryPath + "\" + CheckForUpdatesInTheEndFN) Then
                    Process.Start(My.Application.Info.DirectoryPath + "\" + CheckForUpdatesInTheEndFN)
                End If
            Catch Ex As Exception
            End Try
        End If
        If Not Do_Reboot Then
            End
        Else
            Do_Reboot = False
            If My.Computer.FileSystem.FileExists(My.Application.Info.DirectoryPath + "\" + "UnrealED Dungeon Maker.exe") Then
                Process.Start(My.Application.Info.DirectoryPath + "\" + "UnrealED Dungeon Maker.exe")
            End If
        End If
    End Sub

    Private Sub Main_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        Try
            Try
                LoadPeferences()
                'Pic_Ac_Memory_GHX = System.Drawing.Graphics.FromImage(Pic_Ac_Memory_BMP)
                SetMap(20, 20)
                IMG_Grid = EditorResources.DrawGrid(False)
                IMG_GridWithID = EditorResources.DrawGrid(True)
                IMG_Cursor = EditorResources.CreateSelectionMapEditorBox
                Viewport_MouseMove(sender, New System.Windows.Forms.MouseEventArgs(Windows.Forms.MouseButtons.None, 0, -1, -1, 0))
                'Create Toolbox
                ToolStripComboBoxEditorMode.Text = "Tiles editor"
                LayerSelectionBox.Text = "0"
                Dim counter As Integer = 0
                For Each I As String In My.Computer.FileSystem.GetDirectories(My.Application.Info.DirectoryPath + "\Toolbox")
                    If System.IO.File.Exists(I + "\info.txt") Then
                        If Strings.InStr(System.IO.File.ReadAllText(I + "\info.txt", System.Text.Encoding.Default), "tileset") Then
                            If System.IO.File.Exists(I + "\icon.png") Then
                                If System.IO.File.Exists(I + "\data.txt") Then
                                    IMG_Representations.Add(New UDM_Image(My.Computer.FileSystem.GetDirectoryInfo(I).Name, New System.Drawing.Bitmap(I + "\icon.png")))
                                    ImagesForList.Images.Add(counter, New System.Drawing.Bitmap(I + "\icon.png"))
                                    ToolBox.Items.Add(My.Computer.FileSystem.GetDirectoryInfo(I).Name).ImageIndex = counter
                                Else
                                    MsgBox("Failed loading package: " + My.Computer.FileSystem.GetDirectoryInfo(I).Name + Chr(13) + "Missing 'data.txt'", MsgBoxStyle.Critical)
                                End If
                            Else
                                MsgBox("Failed loading package: " + My.Computer.FileSystem.GetDirectoryInfo(I).Name + Chr(13) + "Missing 'icon.png'", MsgBoxStyle.Critical)
                            End If
                        Else
                            MsgBox("Failed loading package: " + My.Computer.FileSystem.GetDirectoryInfo(I).Name + Chr(13) + "Unknown package type: " + System.IO.File.ReadAllText(I + "\info.txt", System.Text.Encoding.Default), MsgBoxStyle.Critical)
                        End If
                    Else
                        MsgBox("Failed loading package: " + My.Computer.FileSystem.GetDirectoryInfo(I).Name + Chr(13) + "Missing 'info.txt'", MsgBoxStyle.Critical)
                    End If
                    counter += 1
                Next
            Catch Ex As Exception
                MsgBox("An error occured while loading, there is probably something wrong with your toolbox!" + vbNewLine + Ex.Message, MsgBoxStyle.Exclamation)
            End Try
                Me.Show()
                Me.WindowState = FormWindowState.Normal
                My.Application.DoEvents()
                Try
                    Dim YesRNo As String = ""
                    Try
                        If Not My.Computer.FileSystem.DirectoryExists(My.Application.Info.DirectoryPath + "\Settings") Then
                            My.Computer.FileSystem.CreateDirectory(My.Application.Info.DirectoryPath + "\Settings")
                        End If
                        If Not My.Computer.FileSystem.DirectoryExists(My.Application.Info.DirectoryPath + "\Levels") Then
                            My.Computer.FileSystem.CreateDirectory(My.Application.Info.DirectoryPath + "\Levels")
                        End If
                    Catch Ex As Exception
                        MsgBox("Woops there was some kind of error:" + Ex.Message, MsgBoxStyle.Exclamation)
                    End Try
                    YesRNo = ""
                    If My.Computer.FileSystem.FileExists(My.Application.Info.DirectoryPath + "\Settings\showcellprops.cfg") Then
                        YesRNo = System.IO.File.ReadAllText(My.Application.Info.DirectoryPath + "\Settings\showcellprops.cfg", System.Text.Encoding.Default)
                    End If
                    If Not YesRNo = "false" Then
                        'GridToolStripMenuItem.Checked = True
                    End If
                Catch Ex As Exception
                End Try
                Try
                    If Not My.Computer.FileSystem.FileExists(My.Application.Info.DirectoryPath + "\chat.htm") Then
                        System.IO.File.WriteAllText(My.Application.Info.DirectoryPath + "\chat.htm", "<body bgcolor=" + Chr(34) + "#000000" + Chr(34) + "><object width=" + Chr(34) + "200" + Chr(34) + " height=" + Chr(34) + "220" + Chr(34) + " id=" + Chr(34) + "obj_1282925901587" + Chr(34) + "><param name=" + Chr(34) + "movie" + Chr(34) + " value=" + Chr(34) + "http://00UDC.chatango.com/group" + Chr(34) + "/><param name=" + Chr(34) + "AllowScriptAccess" + Chr(34) + " VALUE=" + Chr(34) + "always" + Chr(34) + "/><param name=" + Chr(34) + "AllowNetworking" + Chr(34) + " VALUE=" + Chr(34) + "all" + Chr(34) + "/><param name=" + Chr(34) + "AllowFullScreen" + Chr(34) + " VALUE=" + Chr(34) + "true" + Chr(34) + "/><param name=" + Chr(34) + "flashvars" + Chr(34) + " value=" + Chr(34) + "cid=1282925901587&a=0099FF&b=100&c=FFFFFF&d=FFFFFF&k=0099FF&l=999999&s=1&aa=1" + Chr(34) + "/><embed id=" + Chr(34) + "emb_1282925901587" + Chr(34) + " src=" + Chr(34) + "http://00UDC.chatango.com/group" + Chr(34) + " width=" + Chr(34) + "200" + Chr(34) + " height=" + Chr(34) + "220" + Chr(34) + " allowScriptAccess=" + Chr(34) + "always" + Chr(34) + " allowNetworking=" + Chr(34) + "all" + Chr(34) + " type=" + Chr(34) + "application/x-shockwave-flash" + Chr(34) + " allowFullScreen=" + Chr(34) + "true" + Chr(34) + " flashvars=" + Chr(34) + "cid=1282925901587&a=0099FF&b=100&c=FFFFFF&d=FFFFFF&k=0099FF&l=999999&s=1&aa=1" + Chr(34) + "></embed></object>", System.Text.Encoding.Default)
                    End If
                    '#chatMe.ChatBrowser.Navigate(My.Application.Info.DirectoryPath + "\chat.htm")
                Catch Ex As Exception
                    MsgBox("Woops there was some kind of error:" + Ex.Message, MsgBoxStyle.Exclamation)
                End Try
                InitializeGridCellSettings()
                'Create icons for actors ( speed improvement )
            Catch Ex As Exception
            MsgBox("Having troubles booting, please send this to Henry!" + vbNewLine + Ex.Message)
            End Try
        Try
            If My.Application.CommandLineArgs.Count > 0 Then
                CommandLineLoadMap = True
                CommandLineLoadMapN = My.Application.CommandLineArgs.Item(0).ToString
                LoadDungeonToolStripMenuItem_Click(sender, e)
                CommandLineLoadMap = False
                CommandLineLoadMapN = ""
            End If
        Catch ex As Exception
            MsgBox("Failed opening save file!", MsgBoxStyle.Exclamation)
        End Try
        Splash.Hide()
    End Sub

    Private Sub Viewport_MouseDoubleClick(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles Viewport.MouseDoubleClick
        If e.Button = Windows.Forms.MouseButtons.Middle Then
            SpecialMarkerPos = EditorResources.MouseToViewportPos(e.Location)
            ShowSpecialMaker = True
        End If
    End Sub

    Private Sub Viewport_MouseDown(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles Viewport.MouseDown
        'Capture the initial point
        m_PanStartPoint = New Point(e.X, e.Y)
        'Stop the news for speed preformance
        Ticker.Stop()
        'Redraw and notice I did it:
        Mouse_SpotOnClick = EditorResources.MouseToViewportPos(e.Location)
        If e.Button = Windows.Forms.MouseButtons.Left Then
            Mouse_IsDrawing = True
        End If
        Viewport_MouseMove(sender, e)
    End Sub

    Private Sub Viewport_MouseUp(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles Viewport.MouseUp
        'Resume the news for speed preformance now
        Ticker.Start()
        ' IF RECTANGLE
        If Main.Mouse_IsDrawing And Main.Drawing_Mode = "rectangle" Then
            'ADD ALL TILES LOL
            If ToolBox.SelectedItems.Count > 0 Then
                If Main.Mouse_IsDrawing And Main.Drawing_Mode = "rectangle" Then
                    If Main.Mouse_SpotOnClick.X - 32 < Main.Mouse_SpotOnMove.X Then
                        If Main.Mouse_SpotOnClick.Y < Main.Mouse_SpotOnMove.Y + 32 Then
                            Dim Count = Main.Mouse_SpotOnClick.X
                            Dim Count2 = 0 ' Gets reset every frame
                            'Left Upper
                            While Count < Main.Mouse_SpotOnMove.X - Main.Mouse_SpotOnClick.X
                                Count2 = Mouse_SpotOnClick.Y
                                'MsgBox(Count2.ToString + " < " + (Main.Mouse_SpotOnMove.Y - Main.Mouse_SpotOnClick.Y).ToString)
                                While Count2 < Main.Mouse_SpotOnMove.Y - Main.Mouse_SpotOnClick.Y
                                    Dim XX As New UDM_GRID.UDM_CELL
                                    XX.X = Count + Mouse_SpotOnClick.X
                                    XX.Y = Count2
                                    XX.Tile = ToolBox.SelectedItems.Item(0).Text
                                    AllPoints.Add(XX)
                                    Count2 += 32
                                End While
                                Count += 32
                            End While
                        Else
                            'Right Upper
                        End If
                    ElseIf Main.Mouse_SpotOnClick.X + 32 > Main.Mouse_SpotOnMove.X Then
                        If Main.Mouse_SpotOnClick.Y > Main.Mouse_SpotOnMove.Y - 32 Then
                            'Right Downer
                        Else
                            'Left Downer
                        End If
                    End If
                End If
            End If
        End If
        Mouse_IsDrawing = False
    End Sub

    Public Sub Viewport_MouseMove(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles Viewport.MouseMove
        ' Viewport.BackgroundImage = Nothing
        'Hide ToolTips

        Dim MouseLocationSPEED As System.Drawing.PointF = EditorResources.MouseToViewportPos(e.Location)
        Mouse_SpotOnMove = MouseLocationSPEED
        MainToolTip.Hide(ToolBox)
        Pic_Ac_Memory_GHX.Clear(Preferences.Pref_GridBackgroundColor)
        If GridMode = "nothing" Then
            ShowGrid = False
            ShowGridNumbers = False
        ElseIf GridMode = "grid" Then
            ShowGrid = True
            ShowGridNumbers = False
        ElseIf GridMode = "grid+ID" Then
            ShowGrid = True
            ShowGridNumbers = True
        End If
        ' What about making this BG image
        FrameSkip += 1
        If FrameSkip > FrameSkipAmount Then
            If ShowGrid Then
                If ShowGridNumbers Then
                    Pic_Ac_Memory_GHX.DrawImage(IMG_GridWithID, New PointF(0, 0))
                Else
                    Pic_Ac_Memory_GHX.DrawImage(IMG_Grid, New PointF(0, 0))
                End If
            End If
            EditorResources.DrawOther(Pic_Ac_Memory_GHX)
            Pic_Ac_Memory_GHX.DrawImage(IMG_Cursor, MouseLocationSPEED)
            If ShowSpecialMaker Then
                Pic_Ac_Memory_GHX.DrawImage(SpecialMarkerImg, SpecialMarkerPos)
            End If
        End If
        'Verify Middle Button is pressed while the mouse is moving
        If e.Button = System.Windows.Forms.MouseButtons.Middle Then
            If Not Viewport.Cursor = Cursors.SizeAll Then
                Viewport.Cursor = Cursors.SizeAll
            End If
            'Here we get the change in coordinates.
            Dim DeltaX As Integer = (m_PanStartPoint.X - e.X)
            Dim DeltaY As Integer = (m_PanStartPoint.Y - e.Y)
            'Then we set the new autoscroll position.
            'ALWAYS pass positive integers to the panels autoScrollPosition method
            ViewportPanel.AutoScrollPosition = New Drawing.Point((DeltaX - ViewportPanel.AutoScrollPosition.X), (DeltaY - ViewportPanel.AutoScrollPosition.Y))
        ElseIf e.Button = Windows.Forms.MouseButtons.Left And ToolStripComboBoxEditorMode.Text = "Tiles editor" And Drawing_Mode = "pencil" Then
            If ToolBox.SelectedItems.Count > 0 Then
                'For Each X As UDM_Image In IMG_Representations
                If Not _MAP_HALLWAYS.SContains(Math.Round(MouseLocationSPEED.X), Math.Round(MouseLocationSPEED.Y), "", True) Then ' Does not contain anything
                    'Hold on here, before we add we have to do some if's
                    If (MouseLocationSPEED.X / 32) > -1 And (MouseLocationSPEED.Y / 32) > -1 And (MouseLocationSPEED.X / 32) < MapWidth And (MouseLocationSPEED.Y / 32) < MapHeight Then
                        Dim XT As New UDM_GRID.UDM_CELL
                        XT.Tile = ToolBox.SelectedItems.Item(0).Text
                        XT.X = Math.Round(MouseLocationSPEED.X)
                        XT.Y = Math.Round(MouseLocationSPEED.Y)
                        ' Add more once more is needed
                        XT.Actor = Drawing_Layer
                        AllPoints.Add(XT)
                    End If
                Else
                    Dim XT As New System.Drawing.Point(0, 0)
                    XT.X = Math.Round(EditorResources.MouseToViewportPos(e.Location).X)
                    XT.Y = Math.Round(EditorResources.MouseToViewportPos(e.Location).Y)
                    If RemoveAt(XT) Then
                        'Hold on here, before we add we have to do some if's
                        If (MouseLocationSPEED.X / 32) > -1 And (MouseLocationSPEED.Y / 32) > -1 And (MouseLocationSPEED.X / 32) < MapWidth And (MouseLocationSPEED.Y / 32) < MapHeight Then
                            Dim XTT As New UDM_GRID.UDM_CELL
                            XTT.Tile = ToolBox.SelectedItems.Item(0).Text
                            XTT.X = Math.Round(MouseLocationSPEED.X)
                            XTT.Y = Math.Round(MouseLocationSPEED.Y)
                            ' Add more once more is needed
                            XTT.Actor = Drawing_Layer
                            AllPoints.Add(XTT)
                        End If
                    End If
                End If
            End If
        ElseIf e.Button = Windows.Forms.MouseButtons.Left And ToolStripComboBoxEditorMode.Text = "Actors editor" And Drawing_Mode = "pencil" Then

            'Make sure actor can even be placed here
            If _MAP_HALLWAYS.SContains(Math.Round(MouseLocationSPEED.X), Math.Round(MouseLocationSPEED.Y), "", True) Then

                If Not _MAP_HALLWAYSA.SContains(Math.Round(MouseLocationSPEED.X), Math.Round(MouseLocationSPEED.Y), "", True) Then ' Does not contain anything
                    'Hold on here, before we add we have to do some if's
                    If (MouseLocationSPEED.X / 32) > -1 And (MouseLocationSPEED.Y / 32) > -1 And (MouseLocationSPEED.X / 32) < MapWidth And (MouseLocationSPEED.Y / 32) < MapHeight Then
                        If GC_C_List.SelectedItems.Count > 0 Then
                            Dim XT As New UDM_AGRID.UDM_CELL
                            XT.Tile = GC_C_List.SelectedItems.Item(0).Text
                            XT.X = Math.Round(MouseLocationSPEED.X)
                            XT.Y = Math.Round(MouseLocationSPEED.Y)
                            ' Add more once more is needed
                            XT.Actor = Drawing_Layer
                            AllAPoints.Add(XT)
                        End If
                    End If
                Else
                    Dim XT As New System.Drawing.Point(0, 0)
                    XT.X = Math.Round(MouseLocationSPEED.X)
                    XT.Y = Math.Round(MouseLocationSPEED.Y)
                    If ARemoveAt(XT) Then
                        'Hold on here, before we add we have to do some if's
                        If (MouseLocationSPEED.X / 32) > -1 And (MouseLocationSPEED.Y / 32) > -1 And (MouseLocationSPEED.X / 32) < MapWidth And (MouseLocationSPEED.Y / 32) < MapHeight Then
                            If GC_C_List.SelectedItems.Count > 0 Then
                                Dim XTT As New UDM_AGRID.UDM_CELL
                                XTT.Tile = GC_C_List.SelectedItems.Item(0).Text
                                XTT.X = Math.Round(MouseLocationSPEED.X)
                                XTT.Y = Math.Round(MouseLocationSPEED.Y)
                                ' Add more once more is needed
                                XTT.Actor = Drawing_Layer
                                AllAPoints.Add(XTT)
                            End If
                        End If
                    End If
                End If
            End If
        ElseIf e.Button = Windows.Forms.MouseButtons.Right And ToolStripComboBoxEditorMode.Text = "Tiles editor" And Drawing_Mode = "pencil" Then
            Dim XT As New System.Drawing.Point(0, 0)
            XT.X = Math.Round(MouseLocationSPEED.X)
            XT.Y = Math.Round(MouseLocationSPEED.Y)
            'if there is an actor on top, remove
            If _MAP_HALLWAYSA.SContains(Math.Round(XT.X), Math.Round(XT.Y), "", True) Then
                ARemoveAt(XT, True)
            End If
            RemoveAt(XT, True)
            _MAP_HALLWAYS.SContains(Math.Round(XT.X), Math.Round(XT.Y), "", True)
        ElseIf e.Button = Windows.Forms.MouseButtons.Right And ToolStripComboBoxEditorMode.Text = "Actors editor" And Drawing_Mode = "pencil" Then
            Dim XT As New System.Drawing.Point(0, 0)
            XT.X = Math.Round(MouseLocationSPEED.X)
            XT.Y = Math.Round(MouseLocationSPEED.Y)
            ARemoveAt(XT, True)
        Else
            If Not Viewport.Cursor = Cursors.Default Then
                Viewport.Cursor = Cursors.Default
            End If
        End If
        If FrameSkip > FrameSkipAmount Then
            FrameSkip = 0
            Viewport.Image = Pic_Ac_Memory_BMP
            Me.Update()
            My.Application.DoEvents()
        End If
    End Sub

    Private Function RemoveAt(ByVal apoint As System.Drawing.Point, Optional ByVal JustKill As Boolean = False)
        '_MAP_HALLWAYS.Remove(apoint.X.ToString + ":!:" + apoint.Y.ToString + ":!:" + X.Name)
        Return _MAP_HALLWAYS.Slay(apoint.X, apoint.Y, True, JustKill)
    End Function

    Private Function ARemoveAt(ByVal apoint As System.Drawing.Point, Optional ByVal JustKill As Boolean = False)
        '_MAP_HALLWAYS.Remove(apoint.X.ToString + ":!:" + apoint.Y.ToString + ":!:" + X.Name)
        Return _MAP_HALLWAYSA.Slay(apoint.X, apoint.Y, True, JustKill)
    End Function

    Private Sub ExportDungeonToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ExportDungeonToolStripMenuItem.Click
        Exportt3dForm.Owner = Me
        Exportt3dForm.ShowDialog()
    End Sub

    Private Sub AboutToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles AboutToolStripMenuItem.Click
        Try
            MsgBox("UnrealED dungeon maker is a part of 00Unreal development collection." + vbNewLine + vbNewLine + "Unreal dungeon maker credits:" + vbNewLine + "Programming: Henry00³ ( de Jongh )" + vbNewLine + vbNewLine + "Special thanks goes to:" + vbNewLine + "Smirftsch, for help on some calculations!" + vbNewLine + "Pitbull, for brilliant shape ideas!" + vbNewLine + "Gizzy, even though girlfriend trouble being a nice friend!" + vbNewLine + "Matrix224, for helping when this was still little!" + vbNewLine + "GreatEmerald, for being so awesome on the forums about this!" + vbNewLine + "Pravin, for saying: Cool! Sweet! Yeah! Awesome! Nice! 100 times!" + vbNewLine + "Giygas888, for constantly being an awesome guy!" + vbNewLine + "Dante, for making this editor an editor and kicking my ass around!" + vbNewLine + "Jocke, for being a good programming partner everywhere anywhere!" + vbNewLine + "SkaarjSlayer, for sharing Unreal pawn knowledge!" + vbNewLine + "Head Rebel, I think one of my new best friends now!" + vbNewLine + "ThexDarksider, for helping me hack the *.umx format ( umusic )" + vbNewLine + Strings.Split(My.User.Name, "\").GetValue(1) + ", for using this application right now!", MsgBoxStyle.Information)
        Catch Ex As Exception
            MsgBox("UnrealED dungeon maker is a part of 00Unreal development collection." + vbNewLine + vbNewLine + "Unreal dungeon maker credits:" + vbNewLine + "Programming: Henry00³ ( de Jongh )" + vbNewLine + vbNewLine + "Special thanks goes to:" + vbNewLine + "Smirftsch, for help on some calculations!" + vbNewLine + "Pitbull, for brilliant shape ideas!" + vbNewLine + "Gizzy, even though girlfriend trouble being a nice friend!" + vbNewLine + "Matrix224, for helping when this was still little!" + vbNewLine + "GreatEmerald, for being so awesome on the forums about this!" + vbNewLine + "Pravin, for saying: Cool! Sweet! Yeah! Awesome! Nice! 100 times!" + vbNewLine + "Giygas888, for constantly being an awesome guy!" + vbNewLine + "Dante, for making this editor an editor and kicking my ass around!" + vbNewLine + "Jocke, for being a good programming partner everywhere anywhere!" + vbNewLine + "SkaarjSlayer, for sharing Unreal pawn knowledge!" + vbNewLine + "Head Rebel, I think one of my new best friends now!" + vbNewLine + "ThexDarksider, for helping me hack the *.umx format ( umusic )" + vbNewLine + "You, for using this application right now!", MsgBoxStyle.Information)
        End Try
    End Sub

    Private Sub NewDungeonToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles NewDungeonToolStripMenuItem.Click
        If AllPoints.Count > 0 Or AllAPoints.Count > 0 Or LoadedMapFileName <> "new.<henry" Then
            NewMap.Owner = Me
            NewMap.ShowDialog()
        End If
        Viewport_MouseMove(sender, New System.Windows.Forms.MouseEventArgs(Windows.Forms.MouseButtons.None, 0, -1, -1, 0))
    End Sub

    Private Sub SaveDungeonToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SaveDungeonToolStripMenuItem.Click
        Dim path As String = "poo"
        Dim override As Boolean = False
        If LoadedMapFileFull <> "" And LoadedMapFileFull <> "new.<henry" Then
            override = True
            path = LoadedMapFileFull
        Else
            Dim TSAM As New SaveFileDialog
            TSAM.Title = "UnrealED dungeon maker - Export project as..."
            TSAM.Filter = "UnrealED dungeon maker3 project(*.ud3)|*.ud3|UnrealED dungeon maker2 project(*.ud2)|*.ud2|UnrealED dungeon maker1 project(*.udm)|*.udm"
            TSAM.InitialDirectory = RecentFilePath
            TSAM.ShowDialog()
            path = TSAM.FileName
        End If
        If (path <> "poo" And path <> "") Or override Then
            If Not override Then
                LoadedMapFileFull = My.Computer.FileSystem.GetFileInfo(path).FullName
            End If
            RecentFilePath = My.Computer.FileSystem.GetFileInfo(path).DirectoryName
            Me.Text = My.Computer.FileSystem.GetFileInfo(path).Name + " | " + GUI_Title
            Try
                System.IO.File.WriteAllText(path, "") 'Create and clean file
                Dim count As Integer = 0
                Me.Refresh()
                Me.Enabled = False
                WaitBar.Show()
                If My.Computer.FileSystem.GetFileInfo(path).Extension = ".udm" Then
                    For Each X As UDM_GRID.UDM_CELL In AllPoints
                        Try
                            WaitBar.ProgressBar.Value = Math.Round((count / AllPoints.Count) * 100)
                        Catch ex As Exception
                            MsgBox("Nothing serious, but please report this to Henry00³ ( de Jongh )" + Chr(13) + "ERROR: 1  lol is what I need..", MsgBoxStyle.Question)
                        End Try
                        WaitBar.Refresh()
                        Application.DoEvents()
                        Dim tempString As String = ""
                        If X.Actor = "0" Then
                            tempString = X.X.ToString + ":!:" + X.Y.ToString + ":!:" + X.Tile
                            tempString = Strings.Replace(tempString, "HallToSmallWay D-U", "HallToSmallWay D->U")
                            tempString = Strings.Replace(tempString, "HallToSmallWay U-D", "HallToSmallWay U->D")
                            tempString = Strings.Replace(tempString, "HallToSmallWay L-R", "HallToSmallWay L->R")
                            tempString = Strings.Replace(tempString, "HallToSmallWay R-L", "HallToSmallWay R->L")
                            System.IO.File.AppendAllText(path, tempString + "{!!}", System.Text.Encoding.Default)
                        End If
                        count += 1
                    Next
                ElseIf My.Computer.FileSystem.GetFileInfo(path).Extension = ".ud2" Then
                    For Each X As UDM_GRID.UDM_CELL In AllPoints
                        Try
                            WaitBar.ProgressBar.Value = Math.Round((count / AllPoints.Count) * 100)
                        Catch ex As Exception
                            MsgBox("Nothing serious, but please report this to Henry00³ ( de Jongh )" + Chr(13) + "ERROR: 1  lol is what I need..", MsgBoxStyle.Question)
                        End Try
                        WaitBar.Refresh()
                        Application.DoEvents()
                        Dim tempString As String = ""
                        If X.Actor = "0" Then
                            If Not _MAP_HALLWAYSA.SContains(X.X, X.Y, "", True) Then
                                tempString = X.X.ToString + ":!:" + X.Y.ToString + ":!:" + X.Tile + ":!:"
                            Else
                                tempString = X.X.ToString + ":!:" + X.Y.ToString + ":!:" + X.Tile + ":!:" + _MAP_HALLWAYSA.SContainsTileNameResult + ":!:"
                            End If
                            ' Add layer info
                            tempString += X.Actor
                            System.IO.File.AppendAllText(path, tempString + "{!!}", System.Text.Encoding.Default)
                        End If
                        count += 1
                    Next
                Else ' ud3
                    For Each X As UDM_GRID.UDM_CELL In AllPoints
                        Try
                            WaitBar.ProgressBar.Value = Math.Round((count / AllPoints.Count) * 100)
                        Catch ex As Exception
                            MsgBox("Nothing serious, but please report this to Henry00³ ( de Jongh )" + Chr(13) + "ERROR: 1  lol is what I need..", MsgBoxStyle.Question)
                        End Try
                        WaitBar.Refresh()
                        Application.DoEvents()
                        Dim tempString As String = ""
                        ' Check on its layer if an actor exists
                        If Not _MAP_HALLWAYSA.SContains(X.X, X.Y, "", True, X.Actor) Then
                            tempString = X.X.ToString + ":!:" + X.Y.ToString + ":!:" + X.Tile + ":!:" + "No_UDM_Actor" + ":!:"
                        Else
                            tempString = X.X.ToString + ":!:" + X.Y.ToString + ":!:" + X.Tile + ":!:" + _MAP_HALLWAYSA.SContainsTileNameResult + ":!:"
                        End If
                ' Add layer info
                tempString += X.Actor
                System.IO.File.AppendAllText(path, tempString + "{!!}", System.Text.Encoding.Default)
                count += 1
                    Next
                    ' Now add the additional information for MyMap
                    ' Add music
                    If MyMap_Song <> "" Then
                        System.IO.File.AppendAllText(path, "{!!!}" + "{SONG}" + MyMap_Song, System.Text.Encoding.Default)
                    End If
                    ' Add Layer height settings
                    System.IO.File.AppendAllText(path, "{!!!}" + "{LAYERSHEIGHTSETTINGS}" + MyMap_LayerSetting.ToString, System.Text.Encoding.Default)
                    ' Add author
                    If MyMap_Info_Author <> "" Then
                        System.IO.File.AppendAllText(path, "{!!!}" + "{INFO_AUTHOR}" + MyMap_Info_Author, System.Text.Encoding.Default)
                    End If
                    ' Add comments
                    If MyMap_Info_Comments <> "" Then
                        System.IO.File.AppendAllText(path, "{!!!}" + "{INFO_COMMENTS}" + MyMap_Info_Comments, System.Text.Encoding.Default)
                    End If
                End If
                WaitBar.Close()
                Me.Enabled = True
            Catch Ex As Exception
                MsgBox("Unable to save your project!" + Chr(13) + Ex.Message)
                WaitBar.Close()
                Me.Enabled = True
            End Try
            Me.Focus()
            ' End If
        End If
    End Sub

    Private Sub SaveDungeonAsToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SaveDungeonAsToolStripMenuItem.Click
        Dim path As String = "poo"
        Dim TSAM As New SaveFileDialog
        TSAM.Title = "UnrealED dungeon maker - Export project as..."
        TSAM.Filter = "UnrealED dungeon maker3 project(*.ud3)|*.ud3|UnrealED dungeon maker2 project(*.ud2)|*.ud2|UnrealED dungeon maker1 project(*.udm)|*.udm"
        TSAM.InitialDirectory = RecentFilePath
        TSAM.ShowDialog()
        path = TSAM.FileName
        If path <> "poo" And path <> "" Then
            LoadedMapFileFull = My.Computer.FileSystem.GetFileInfo(path).FullName
            RecentFilePath = My.Computer.FileSystem.GetFileInfo(path).DirectoryName
            Me.Text = My.Computer.FileSystem.GetFileInfo(path).Name + " | " + GUI_Title
            Try
                System.IO.File.WriteAllText(path, "") 'Create and clean file
                Dim count As Integer = 0
                Me.Refresh()
                Me.Enabled = False
                WaitBar.Show()
                If My.Computer.FileSystem.GetFileInfo(path).Extension = ".udm" Then
                    For Each X As UDM_GRID.UDM_CELL In AllPoints
                        Try
                            WaitBar.ProgressBar.Value = Math.Round((count / AllPoints.Count) * 100)
                        Catch ex As Exception
                            MsgBox("Nothing serious, but please report this to Henry00³ ( de Jongh )" + Chr(13) + "ERROR: 1  lol is what I need..", MsgBoxStyle.Question)
                        End Try
                        WaitBar.Refresh()
                        Application.DoEvents()
                        Dim tempString As String = ""
                        If X.Actor = "0" Then
                            tempString = X.X.ToString + ":!:" + X.Y.ToString + ":!:" + X.Tile
                            tempString = Strings.Replace(tempString, "HallToSmallWay D-U", "HallToSmallWay D->U")
                            tempString = Strings.Replace(tempString, "HallToSmallWay U-D", "HallToSmallWay U->D")
                            tempString = Strings.Replace(tempString, "HallToSmallWay L-R", "HallToSmallWay L->R")
                            tempString = Strings.Replace(tempString, "HallToSmallWay R-L", "HallToSmallWay R->L")
                            System.IO.File.AppendAllText(path, tempString + "{!!}", System.Text.Encoding.Default)
                        End If
                        count += 1
                    Next
                ElseIf My.Computer.FileSystem.GetFileInfo(path).Extension = ".ud2" Then
                    For Each X As UDM_GRID.UDM_CELL In AllPoints
                        Try
                            WaitBar.ProgressBar.Value = Math.Round((count / AllPoints.Count) * 100)
                        Catch ex As Exception
                            MsgBox("Nothing serious, but please report this to Henry00³ ( de Jongh )" + Chr(13) + "ERROR: 1  lol is what I need..", MsgBoxStyle.Question)
                        End Try
                        WaitBar.Refresh()
                        Application.DoEvents()
                        Dim tempString As String = ""
                        If X.Actor = "0" Then
                            If Not _MAP_HALLWAYSA.SContains(X.X, X.Y, "", True) Then
                                tempString = X.X.ToString + ":!:" + X.Y.ToString + ":!:" + X.Tile + ":!:"
                            Else
                                tempString = X.X.ToString + ":!:" + X.Y.ToString + ":!:" + X.Tile + ":!:" + _MAP_HALLWAYSA.SContainsTileNameResult + ":!:"
                            End If
                            ' Add layer info
                            tempString += X.Actor
                            System.IO.File.AppendAllText(path, tempString + "{!!}", System.Text.Encoding.Default)
                        End If
                        count += 1
                    Next
                Else ' ud3
                    For Each X As UDM_GRID.UDM_CELL In AllPoints
                        Try
                            WaitBar.ProgressBar.Value = Math.Round((count / AllPoints.Count) * 100)
                        Catch ex As Exception
                            MsgBox("Nothing serious, but please report this to Henry00³ ( de Jongh )" + Chr(13) + "ERROR: 1  lol is what I need..", MsgBoxStyle.Question)
                        End Try
                        WaitBar.Refresh()
                        Application.DoEvents()
                        Dim tempString As String = ""
                        ' Check on its layer if an actor exists
                        If Not _MAP_HALLWAYSA.SContains(X.X, X.Y, "", True, X.Actor) Then
                            tempString = X.X.ToString + ":!:" + X.Y.ToString + ":!:" + X.Tile + ":!:" + "No_UDM_Actor" + ":!:"
                        Else
                            tempString = X.X.ToString + ":!:" + X.Y.ToString + ":!:" + X.Tile + ":!:" + _MAP_HALLWAYSA.SContainsTileNameResult + ":!:"
                        End If
                        ' Add layer info
                        tempString += X.Actor
                        System.IO.File.AppendAllText(path, tempString + "{!!}", System.Text.Encoding.Default)
                        count += 1
                    Next
                    ' Now add the additional information for MyMap
                    ' Add music
                    If MyMap_Song <> "" Then
                        System.IO.File.AppendAllText(path, "{!!!}" + "{SONG}" + MyMap_Song, System.Text.Encoding.Default)
                    End If
                    ' Add Layer height settings
                    System.IO.File.AppendAllText(path, "{!!!}" + "{LAYERSHEIGHTSETTINGS}" + MyMap_LayerSetting.ToString, System.Text.Encoding.Default)
                    ' Add author
                    If MyMap_Info_Author <> "" Then
                        System.IO.File.AppendAllText(path, "{!!!}" + "{INFO_AUTHOR}" + MyMap_Info_Author, System.Text.Encoding.Default)
                    End If
                    ' Add comments
                    If MyMap_Info_Comments <> "" Then
                        System.IO.File.AppendAllText(path, "{!!!}" + "{INFO_COMMENTS}" + MyMap_Info_Comments, System.Text.Encoding.Default)
                    End If
                End If
                WaitBar.Close()
                Me.Enabled = True
            Catch Ex As Exception
                MsgBox("Unable to save your project!" + vbNewLine + Ex.Message)
                WaitBar.Close()
                Me.Enabled = True
            End Try
            Me.Focus()
            ' End If
        End If
    End Sub

    Private Sub LoadDungeonToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles LoadDungeonToolStripMenuItem.Click
        Dim OpenFileDialog1 As New OpenFileDialog
        Dim ToOpenPath As String = CommandLineLoadMapN
        If Not CommandLineLoadMap Then
            OpenFileDialog1.CheckFileExists = True
            OpenFileDialog1.CheckPathExists = True
            'no def. ext.
            OpenFileDialog1.FileName = ""
            OpenFileDialog1.Filter = "All dungeon maker projects(*.ud3;*.ud2;*.udm)|*.ud3;*.ud2;*.udm|UnrealED dungeon maker3 project(*.ud3)|*.ud3|UnrealED dungeon maker2 project(*.ud2)|*.ud2|UnrealED dungeon maker1 project(*.udm)|*.udm"
            OpenFileDialog1.Multiselect = False
            OpenFileDialog1.InitialDirectory = RecentFilePath
            OpenFileDialog1.ShowDialog()
            ToOpenPath = OpenFileDialog1.FileName
        End If
        If ToOpenPath <> "" Then
            RecentFilePath = My.Computer.FileSystem.GetFileInfo(ToOpenPath).DirectoryName
            LoadedMapFileFull = My.Computer.FileSystem.GetFileInfo(ToOpenPath).FullName
            Me.Text = My.Computer.FileSystem.GetFileInfo(ToOpenPath).Name + " | " + GUI_Title
            AllPoints.Clear()
            AllAPoints.Clear()
            MyMap_LayerSetting = 0
            MyMap_Song = ""
            MyMap_Info_Author = ""
            MyMap_Info_Comments = ""
            If My.Computer.FileSystem.GetFileInfo(ToOpenPath).Extension = ".udm" Then
                Dim TempArray As Array = Nothing
                Try
                    For Each X As String In Strings.Split(My.Computer.FileSystem.ReadAllText(ToOpenPath, System.Text.Encoding.Default), "{!!}")
                        If X <> "" Then
                            TempArray = Strings.Split(X, ":!:")
                            If TempArray.Length > 2 Then
                                Dim NewTile As New UDM_GRID.UDM_CELL
                                NewTile.X = TempArray.GetValue(0)
                                NewTile.Y = TempArray.GetValue(1)
                                NewTile.Tile = TempArray.GetValue(2)
                                NewTile.Tile = Strings.Replace(NewTile.Tile, "HallToSmallWay D->U", "HallToSmallWay D-U")
                                NewTile.Tile = Strings.Replace(NewTile.Tile, "HallToSmallWay U->D", "HallToSmallWay U-D")
                                NewTile.Tile = Strings.Replace(NewTile.Tile, "HallToSmallWay L->R", "HallToSmallWay L-R")
                                NewTile.Tile = Strings.Replace(NewTile.Tile, "HallToSmallWay R->L", "HallToSmallWay R-L")
                                NewTile.Actor = "0" ' Has no idea what layers are
                                AllPoints.Add(NewTile)
                            End If
                        End If
                    Next
                Catch ex As Exception
                    MsgBox("Error loading map file!" + ex.Message + vbNewLine + vbNewLine + "Please note that this is the old UnrealED dungeon maker1 format, it is no longer supported for updates or bugfixes.")
                End Try
            ElseIf My.Computer.FileSystem.GetFileInfo(ToOpenPath).Extension = ".ud2" Then
                Dim TempArray As Array = Nothing
                Try
                    For Each X As String In Strings.Split(My.Computer.FileSystem.ReadAllText(ToOpenPath, System.Text.Encoding.Default), "{!!}")
                        If X <> "" Then
                            TempArray = Strings.Split(X, ":!:")
                            If TempArray.Length > 3 Then ' Has actor info
                                Dim NewTile As New UDM_GRID.UDM_CELL
                                Dim NewATile As New UDM_AGRID.UDM_CELL
                                NewTile.X = TempArray.GetValue(0)
                                NewTile.Y = TempArray.GetValue(1)
                                NewATile.X = TempArray.GetValue(0)
                                NewATile.Y = TempArray.GetValue(1)
                                NewTile.Tile = TempArray.GetValue(2)
                                NewATile.Tile = TempArray.GetValue(3)
                                NewTile.Actor = "0"
                                NewATile.Actor = "0"
                                AllPoints.Add(NewTile)
                                AllAPoints.Add(NewATile)
                            ElseIf TempArray.Length > 2 Then ' No actor info
                                Dim NewTile As New UDM_GRID.UDM_CELL
                                NewTile.X = TempArray.GetValue(0)
                                NewTile.Y = TempArray.GetValue(1)
                                NewTile.Tile = TempArray.GetValue(2)
                                NewTile.Actor = "0"
                                AllPoints.Add(NewTile)
                            End If
                        End If
                    Next
                Catch ex As Exception
                    MsgBox("Error loading map file!" + ex.Message + vbNewLine + vbNewLine + "Please note that this is the old UnrealED dungeon maker1 format, it is no longer supported for updates or bugfixes.")
                End Try
            Else ' ud3
                Dim TempArray As Array = Nothing
                Try
                    Dim MiniCount As Integer = 0
                    For Each XX As String In Strings.Split(My.Computer.FileSystem.ReadAllText(ToOpenPath, System.Text.Encoding.Default), "{!!!}")

                        If MiniCount = 0 Then ' LOAD MAP

                            For Each X As String In Strings.Split(XX, "{!!}")
                                If X <> "" Then
                                    TempArray = Strings.Split(X, ":!:")
                                    ' Create new CELLs
                                    Dim NewTile As New UDM_GRID.UDM_CELL
                                    Dim NewATile As New UDM_AGRID.UDM_CELL
                                    ' Set X and Y on both
                                    NewTile.X = TempArray.GetValue(0)
                                    NewTile.Y = TempArray.GetValue(1)
                                    NewATile.X = TempArray.GetValue(0)
                                    NewATile.Y = TempArray.GetValue(1)
                                    ' There is always tile info
                                    NewTile.Tile = TempArray.GetValue(2)
                                    ' If not none then add actor info
                                    If TempArray.GetValue(3) <> "No_UDM_Actor" Then
                                        NewATile.Tile = TempArray.GetValue(3)
                                    Else
                                        NewATile.Tile = "" ' UDM understands
                                    End If
                                    ' Layer does always exist, set on both
                                    NewTile.Actor = TempArray.GetValue(4)
                                    NewATile.Actor = TempArray.GetValue(4)
                                    AllPoints.Add(NewTile)
                                    AllAPoints.Add(NewATile)
                                End If
                            Next

                        Else ' Load additional information
                            Dim TempString As String = ""
                            If Strings.InStr(XX, "{SONG}") Then
                                TempString = Strings.Replace(XX, "{SONG}", "")
                                MyMap_Song = TempString
                            End If
                            TempString = ""
                            If Strings.InStr(XX, "{LAYERSHEIGHTSETTINGS}") Then
                                TempString = Strings.Replace(XX, "{LAYERSHEIGHTSETTINGS}", "")
                                MyMap_LayerSetting = TempString
                            End If
                            TempString = ""
                            If Strings.InStr(XX, "{INFO_AUTHOR}") Then
                                TempString = Strings.Replace(XX, "{INFO_AUTHOR}", "")
                                MyMap_Info_Author = TempString
                            End If
                            TempString = ""
                            If Strings.InStr(XX, "{INFO_COMMENTS}") Then
                                TempString = Strings.Replace(XX, "{INFO_COMMENTS}", "")
                                MyMap_Info_Comments = TempString
                            End If
                            TempString = ""
                        End If
                        MiniCount += 1
                    Next
                Catch ex As Exception
                    MsgBox("Error loading map file!" + ex.Message + vbNewLine + vbNewLine + "Please note that if this is the old UnrealED dungeon maker1 or 2 format, it is no longer supported for updates or bugfixes.")
                End Try
            End If
            Viewport_MouseMove(sender, New System.Windows.Forms.MouseEventArgs(Windows.Forms.MouseButtons.None, 0, -1, -1, 0))
        End If
        CommandLineLoadMap = False
        CommandLineLoadMapN = ""
    End Sub

    Private Sub HelpOnKeysToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles HelpOnKeysToolStripMenuItem.Click
        MsgBox("-On all the drawing surfaces you can use the middle mousebutton to" + Chr(13) + "  scroll around." + Chr(13) + "-On the map designer the left mouse button is for adding the" + Chr(13) + "  ( in the toolbox selected ) map part." + Chr(13) + "-Using the right mousebutton you can remove map parts.", MsgBoxStyle.Information)
    End Sub

    Private Sub ToolBox_ItemMouseHover(ByVal sender As Object, ByVal e As System.Windows.Forms.ListViewItemMouseHoverEventArgs) Handles ToolBox.ItemMouseHover
        Try
            If My.Computer.FileSystem.FileExists(My.Application.Info.DirectoryPath + "\Toolbox\" + e.Item.Text + "\about.txt") Then
                HideCounter_01 = 0
                MainToolTip.ToolTipTitle = "About " + e.Item.Text
                Dim TempPos As System.Drawing.Point = Me.ToolBox.PointToClient(System.Windows.Forms.Control.MousePosition)
                TempPos.X += 40
                MainToolTip.Show(System.IO.File.ReadAllText(My.Application.Info.DirectoryPath + "\Toolbox\" + e.Item.Text + "\about.txt", System.Text.Encoding.Default), ToolBox, TempPos)
            End If
        Catch Ex As Exception
        End Try
    End Sub

    Public Sub InitializeGridCellSettings()
        Dim Count As Integer = 0
        For Each I As String In My.Computer.FileSystem.GetDirectories(My.Application.Info.DirectoryPath + "\Actors")
            If My.Computer.FileSystem.FileExists(I + "\icon.png") Then
                If My.Computer.FileSystem.FileExists(I + "\data.txt") Then
                    If My.Computer.FileSystem.FileExists(I + "\about.txt") Then
                        ActorsImages.Images.Add(New Bitmap(I + "\icon.png"))
                        GC_C_List.Items.Add(My.Computer.FileSystem.GetDirectoryInfo(I).Name, Count)
                        Count += 1
                        EditorResources.AllActorBitmaps.Add(New UDM_Image(My.Computer.FileSystem.GetDirectoryInfo(I).Name, New Bitmap(I + "\icon.png")))
                    Else
                        MsgBox("Failed loading Actor: " + I + " about.txt is missing!")
                    End If
                Else
                    MsgBox("Failed loading Actor: " + I + " data.txt is missing!")
                End If
            Else
                MsgBox("Failed loading Actor: " + I + " icon.png is missing!")
            End If
        Next
        GC_C_List.Sort()
    End Sub

    Private Sub GC_C_List_ItemMouseHover(ByVal sender As Object, ByVal e As System.Windows.Forms.ListViewItemMouseHoverEventArgs) Handles GC_C_List.ItemMouseHover
        Dim GC_C_Discription As String = ""
        GC_C_Discription = "" ' Header will always be set
        Dim GC_C_DiscriptionHeader As String = ""
        Dim BK As String = e.Item.Text
        Try
            If My.Computer.FileSystem.FileExists(My.Application.Info.DirectoryPath + "\Actors\" + BK + "\about.txt") Then
                Dim TheText As Array = Strings.Split(System.IO.File.ReadAllText(My.Application.Info.DirectoryPath + "\Actors\" + BK + "\about.txt", System.Text.Encoding.Default), "||")
                If TheText.Length > 1 Then
                    GC_C_DiscriptionHeader = TheText.GetValue(0)
                    GC_C_Discription = TheText.GetValue(1)
                Else
                    GC_C_DiscriptionHeader = TheText.GetValue(0)
                End If
            End If
        Catch Ex As Exception
        Finally
            HideCounter_01 = 0
            MainToolTip.ToolTipTitle = "About " + GC_C_DiscriptionHeader
            Dim TempPos As System.Drawing.Point = Me.GC_C_List.PointToClient(System.Windows.Forms.Control.MousePosition)
            TempPos.X += 40
            MainToolTip.Show(GC_C_Discription, GC_C_List, TempPos)
        End Try
    End Sub

    Private Sub PrefrencesToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PeferencesToolStripMenuItem.Click
        Preferences.Owner = Me
        Preferences.ShowDialog()
    End Sub

    Public Sub LoadPeferences()
        Try
            If My.Computer.FileSystem.FileExists(My.Application.Info.DirectoryPath + "\settings\pref_gridbackgroundcolor.cfg") Then
                Preferences.Pref_GridBackgroundColor = System.Drawing.Color.FromArgb(CType(System.IO.File.ReadAllText(My.Application.Info.DirectoryPath + "\settings\pref_gridbackgroundcolor.cfg", System.Text.Encoding.Default), Integer))
            Else
                Preferences.Pref_GridBackgroundColor = Color.Gray
            End If
        Catch ex As Exception
            Preferences.Pref_GridBackgroundColor = Color.Gray
        End Try

        Try
            If My.Computer.FileSystem.FileExists(My.Application.Info.DirectoryPath + "\settings\pref_gridforegroundcolor.cfg") Then
                Preferences.Pref_GridForegroundColor = System.Drawing.Color.FromArgb(CType(System.IO.File.ReadAllText(My.Application.Info.DirectoryPath + "\settings\pref_gridforegroundcolor.cfg", System.Text.Encoding.Default), Integer))
            Else
                Preferences.Pref_GridForegroundColor = Color.Black
            End If
        Catch ex As Exception
            Preferences.Pref_GridForegroundColor = Color.Black
        End Try

        Try
            If My.Computer.FileSystem.FileExists(My.Application.Info.DirectoryPath + "\settings\pref_gridselectioncolor.cfg") Then
                Preferences.Pref_GridSelectionColor = System.Drawing.Color.FromArgb(CType(System.IO.File.ReadAllText(My.Application.Info.DirectoryPath + "\settings\pref_gridselectioncolor.cfg", System.Text.Encoding.Default), Integer))
            Else
                Preferences.Pref_GridSelectionColor = Color.WhiteSmoke
            End If
        Catch ex As Exception
            Preferences.Pref_GridSelectionColor = Color.WhiteSmoke
        End Try

        Try
            If My.Computer.FileSystem.FileExists(My.Application.Info.DirectoryPath + "\settings\pref_frameskip20.cfg") Then
                Preferences.Pref_FrameSkip20 = CType(System.IO.File.ReadAllText(My.Application.Info.DirectoryPath + "\settings\pref_frameskip20.cfg", System.Text.Encoding.Default), Integer)
            Else
                Preferences.Pref_FrameSkip20 = 0
            End If
        Catch ex As Exception
            Preferences.Pref_FrameSkip20 = 0
        End Try

        Try
            If My.Computer.FileSystem.FileExists(My.Application.Info.DirectoryPath + "\settings\pref_frameskip40.cfg") Then
                Preferences.Pref_FrameSkip40 = CType(System.IO.File.ReadAllText(My.Application.Info.DirectoryPath + "\settings\pref_frameskip40.cfg", System.Text.Encoding.Default), Integer)
            Else
                Preferences.Pref_FrameSkip40 = 0
            End If
        Catch ex As Exception
            Preferences.Pref_FrameSkip40 = 0
        End Try

        Try
            If My.Computer.FileSystem.FileExists(My.Application.Info.DirectoryPath + "\settings\pref_frameskip80.cfg") Then
                Preferences.Pref_FrameSkip80 = CType(System.IO.File.ReadAllText(My.Application.Info.DirectoryPath + "\settings\pref_frameskip80.cfg", System.Text.Encoding.Default), Integer)
            Else
                Preferences.Pref_FrameSkip80 = 0
            End If
        Catch ex As Exception
            Preferences.Pref_FrameSkip80 = 0
        End Try

        ChangeFrameSkip()
    End Sub

    Public Structure UDM_GDCELL
        Public Tile As String
        Public CanGoUp As Boolean
        Public CanGoDown As Boolean
        Public CanGoLeft As Boolean
        Public CanGoRight As Boolean
        Public Sub New(ByVal _Tile As String, ByVal _CanGoUp As Boolean, ByVal _CanGoDown As Boolean, ByVal _CanGoLeft As Boolean, ByVal _CanGoRight As Boolean)
            Tile = _Tile
            CanGoUp = _CanGoUp
            CanGoDown = _CanGoDown
            CanGoLeft = _CanGoLeft
            CanGoRight = _CanGoRight
        End Sub
    End Structure
    Private Sub GenerateDungeonToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles GenerateDungeonToolStripMenuItem.Click
        MsgBox("Sorry, but this feature is unavailable!", MsgBoxStyle.Exclamation)

        'If AllPoints.Count > 0 Or AllAPoints.Count > 0 Then
        '    If MsgBox("Would you like to save your dungeon?", MsgBoxStyle.YesNo) = MsgBoxResult.Yes Then
        '        SaveDungeonToolStripMenuItem_Click(sender, e)
        '    End If
        'End If
        ''--- GENERATE DUNGEON START ---------------

        'Dim PossibleTiles As New List(Of UDM_GDCELL)

        '' Find Tiles that have dg_info settings
        'For Each I As UDM_Image In IMG_Representations
        '    If My.Computer.FileSystem.FileExists(My.Application.Info.DirectoryPath + "\Toolbox\" + I.Name + "\dg_info.txt") Then
        '        Dim X As String = System.IO.File.ReadAllText(My.Application.Info.DirectoryPath + "\Toolbox\" + I.Name + "\dg_info.txt")
        '        Dim _CanGoUp As Boolean = False
        '        Dim _CanGoDown As Boolean = False
        '        Dim _CanGoLeft As Boolean = False
        '        Dim _CanGoRight As Boolean = False
        '        If Strings.InStr(X, "(U)") Then
        '            _CanGoUp = True
        '        End If
        '        If Strings.InStr(X, "(D)") Then
        '            _CanGoDown = True
        '        End If
        '        If Strings.InStr(X, "(L)") Then
        '            _CanGoLeft = True
        '        End If
        '        If Strings.InStr(X, "(R)") Then
        '            _CanGoRight = True
        '        End If
        '        Try
        '            PossibleTiles.Add(New UDM_GDCELL(I.Name, _CanGoUp, _CanGoDown, _CanGoLeft, _CanGoRight))
        '        Catch ex As Exception
        '            MsgBox("Failed to generate dungeon, trouble with tile: " + I.ToString + vbNewLine + ex.Message)
        '            Exit Sub ' To be sure..
        '        End Try
        '    End If
        'Next

        'If PossibleTiles.Count > 0 Then
        '    ' All tiles ok, we move on, lets generate!
        '    AllAPoints.Clear()
        '    AllPoints.Clear()
        '    ' ---
        'Else
        '    MsgBox("For some reason all your tiles have no dungeon generator information!" + vbNewLine + "Its called dg_info.txt and contents like: (D),(U),(L),(R)")
        'End If

        '--- GENERATE DUNGEON END -----------------
    End Sub

    Private Sub UpdateResourcesToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles UpdateResourcesToolStripMenuItem.Click
        Dim BK As String = Downloading.Label1.Text
        Try
            Downloading.Owner = Me
            Downloading.Show()
            Downloading.Label1.Text = "Scanning for Resources"
            Me.Enabled = False
            ' START
            ' First, get the tiles info
            Dim TilesInfo As String = ""
            Try
                TilesInfo = New Net.WebClient().DownloadString(New System.Uri(ServerLink + "Henry00/00UDC/dungeon maker/Resources/TileInfo.txt"))
            Catch Ex As Exception
                StopURTSMI_C(BK)
                MsgBox("Failed updating resources! Maybe the server is offline." + vbNewLine + "Please try again later." + vbNewLine + vbNewLine + Ex.Message, MsgBoxStyle.Exclamation)
                Exit Sub
            End Try
            Try
                While Strings.InStr(TilesInfo, Chr(10))
                    TilesInfo = Strings.Replace(TilesInfo, Chr(10), "")
                End While
                While Strings.InStr(TilesInfo, Chr(13))
                    TilesInfo = Strings.Replace(TilesInfo, Chr(13), "")
                End While
                While Strings.InStr(TilesInfo, vbNewLine)
                    TilesInfo = Strings.Replace(TilesInfo, vbNewLine, "")
                End While
            Catch ex As Exception
                MsgBox("Failed updating resources! Internal error." + vbNewLine + "Please try again later." + vbNewLine + vbNewLine + ex.Message, MsgBoxStyle.Exclamation)
                Exit Sub
            End Try
            Dim CurrentArgument As Integer = 0
            Dim TotalArgument As Integer = 0
            Dim CurrentSection As String = ""
            Dim CurrentName As String = ""
            Dim CurrentVersion As String = ""
            Dim GoDownload As Boolean = False
            Dim HasUpdated As Boolean = False
            ' We retreived the tiles info, lets read and see:
            For Each Line As String In Strings.Split(TilesInfo, "{n}")
                CurrentSection = ""
                CurrentName = ""
                CurrentArgument = 0
                GoDownload = False
                ' In each line its: Section - Name - Version - filelist
                For Each Argument As String In Strings.Split(Line, ":!:")
                    If CurrentArgument = 0 Then ' Section
                        CurrentSection = Argument
                    ElseIf CurrentArgument = 1 Then ' Name
                        CurrentName = Argument
                    End If
                    If CurrentArgument = 2 Then ' Version
                        ' Check if version is not 0 ( skip )
                        CurrentVersion = Argument
                        If Argument <> 0 Then
                            ' Check if this file exists already, if not we download
                            If My.Computer.FileSystem.FileExists(My.Application.Info.DirectoryPath + "\" + CurrentSection + "\" + CurrentName + "\cversion.txt") Then
                                ' It exists, if equal to our argument we skip, else we download
                                Try
                                    If System.IO.File.ReadAllText(My.Application.Info.DirectoryPath + "\" + CurrentSection + "\" + CurrentName + "\cversion.txt", System.Text.Encoding.Default) = Argument Then
                                        'Nvm, the version is thesame
                                    Else
                                        'Go download
                                        GoDownload = True
                                        HasUpdated = True
                                    End If
                                Catch ex As Exception
                                    'It failed, goto next pff
                                    GoDownload = False
                                End Try
                            Else
                                ' It does not exist, we download
                                GoDownload = True
                                HasUpdated = True
                            End If
                        End If
                    End If
                    If CurrentArgument > 2 And GoDownload Then ' Fileslist
                        Downloading.Label1.Text = "Checking: " + CurrentArgument.ToString + "/" + TotalArgument.ToString + vbNewLine + "Downloading: " + CurrentName
                        Downloading.Update()
                        My.Application.DoEvents()
                        Dim oh As New Net.WebClient
                        Try
                            If Not My.Computer.FileSystem.DirectoryExists(My.Application.Info.DirectoryPath + "\" + CurrentSection + "\" + CurrentName) Then
                                My.Computer.FileSystem.CreateDirectory(My.Application.Info.DirectoryPath + "\" + CurrentSection + "\" + CurrentName)
                            End If
                            oh.DownloadFile(New System.Uri(ServerLink + "Henry00/00UDC/dungeon maker/Resources/" + CurrentSection + "/" + CurrentName + "/" + Argument), My.Application.Info.DirectoryPath + "\" + CurrentSection + "\" + CurrentName + "\" + Argument)
                        Catch Ex As Exception
                        Finally
                            oh.Dispose()
                        End Try
                        System.IO.File.WriteAllText(My.Application.Info.DirectoryPath + "\" + CurrentSection + "\" + CurrentName + "\cversion.txt", CurrentVersion, System.Text.Encoding.Default)
                    Else
                        'Nvm, no downloading its already good, goto next actually
                    End If
                    CurrentArgument += 1
                    TotalArgument += 1
                Next
            Next
            If HasUpdated Then
                MsgBox("New resources have been installed!" + vbNewLine + "UnrealED Dungeon Maker will now reboot.", MsgBoxStyle.Information)
                Downloading.Label1.Text = "Installing Resources..."
                Do_Reboot = True
                Me.Close()
            Else
                MsgBox("No new resources have been installed!", MsgBoxStyle.Information)
            End If
            ' END
            StopURTSMI_C(BK)
        Catch Ex As Exception
            StopURTSMI_C(BK)
            MsgBox("Failed updating resources!" + vbNewLine + "Please try again later.", MsgBoxStyle.Exclamation)
        End Try

    End Sub
    Private Sub StopURTSMI_C(ByVal BK As String)
        Me.Enabled = True
        Downloading.Close()
        Downloading.Label1.Text = BK
    End Sub

    Private Sub LayerSelectionBox_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles LayerSelectionBox.SelectedIndexChanged
        Drawing_Layer = LayerSelectionBox.Text
        Viewport_MouseMove(e, New System.Windows.Forms.MouseEventArgs(Windows.Forms.MouseButtons.None, 0, -1, -1, 0))
    End Sub

End Class
